//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui](index.md)/[BotStacksThemeEngine](-bot-stacks-theme-engine.md)

# BotStacksThemeEngine

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [BotStacksThemeEngine](-bot-stacks-theme-engine.md)(useDarkTheme: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = isSystemInDarkTheme(), lightColorScheme: [Colors](../ai.botstacks.sdk.ui.theme/-colors/index.md) = LocalBotStacksDayNightColorScheme.current.day, darkColorScheme: [Colors](../ai.botstacks.sdk.ui.theme/-colors/index.md) = LocalBotStacksDayNightColorScheme.current.night, shapes: [ShapeDefinitions](../ai.botstacks.sdk.ui.theme/-shape-definitions/index.md)? = null, assets: [Assets](../ai.botstacks.sdk.ui.theme/-assets/index.md)? = null, fonts: [Fonts](../ai.botstacks.sdk.ui.theme/-fonts/index.md)? = null, content: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

The Theme Engine that drives BotStacks UI.

#### Parameters

common

| | |
|---|---|
| useDarkTheme | Whether to use the dark theme supplied in [darkColorScheme](-bot-stacks-theme-engine.md). This defaults to the system setting for Light vs. Dark and respects Auto settings. |
| lightColorScheme | The [Colors](../ai.botstacks.sdk.ui.theme/-colors/index.md) to utilize when [useDarkTheme](-bot-stacks-theme-engine.md) is false. |
| darkColorScheme | The [Colors](../ai.botstacks.sdk.ui.theme/-colors/index.md) to utilize when [useDarkTheme](-bot-stacks-theme-engine.md) is true. |
| shapes | The shape definitions to use for component rendering. |
| assets | Various assets used throughout the components (empty states, logo) |
| fonts | The fonts to utilize for all Text within Components. |
